################################################################################
## MUSIC ROOM DECLARATION
################################################################################
init python:
    #################### STEP 1: Set up the music room.
    ## You can make multiple music rooms consisting of different sets of tracks,
    ## if you so desire, or use one music room for all your music. You only need
    ## to pass in the name of the ExtendedMusicRoom object you set up here to
    ## the music room screens below.

    ## You can pass any of the following arguments to ExtendedMusicRoom:
    ## channel: The channel to play the music on. Defaults to 'music'.
    ## fadeout: The time in seconds to fade out the old song when changing
    ##          tracks. Defaults to 0.0 (no fade).
    ## fadein: The time in seconds to fade in the new song when changing tracks.
    ##         Defaults to 0.0 (no fade).
    ## loop: Whether to loop the music when reaching the end of the track list.
    ##       Defaults to True and can be toggled in the music room with a
    ##       button.
    ## single_track: If True, only a single track will loop. Defaults to False
    ##               and can be toggled in the music room with a button.
    ## shuffle: Whether to shuffle the tracks or play them in default order.
    ##          Defaults to False and can be toggled in the music room with a
    ##          button.
    ## stop_action: A screen action to run when the music stops. Defaults to
    ##              None, so no action is run.
    ## alphabetical : If True, the tracks will be sorted alphabetically.
    ##                If False, the default, they will be arranged in the order
    ##                they are added to the music room in.
    music_room = ExtendedMusicRoom(channel='music', fadeout=0.0, fadein=0.0,
        loop=True, single_track=False, shuffle=False, stop_action=None,
        alphabetical=True)

    ## This sets up a default art image for all tracks in this room which aren't
    ## given a more specific one. This default art is 600x600, but several
    ## layouts resize it. It should typically be square.
    music_room.default_art = "gui/music_room/cover_art.webp"

    ## Now you can declare the music files. These will appear in the music room
    ## in the order you declare them in, unless you set alphabetical=True above.
    #music_room.add(
        ## The title of the song. Used for alphabetization. Should probably
        ## be translatable.
        #name=_("Dance of the Sugar Plum Fairy"),
        ## This should be the path to the song i.e. "audio/music/sugar_plum.ogg"
        #path="<silence 124>",
        ## The song artist. Optional; depends on how you want to set up
        ## your screens. The default layouts use the artist field.
        #artist="Pyotr Ilyich Tchaikovsky",
        ############ The following are more optional fields ####################
        ## This can be the path to album art specific for this song. If not
        ## provided/it is None (the default), it'll use the default_art,
        ## provided above. You can provide Null() if you'd like no image at all,
        ## not even the default.
        #art=None,
        ## An optional extra field. You can put whatever information you like
        ## in here and display it however you want in the music room screen.
        ## By default, the screens do not display this information.
        #description=_("From {i}The Nutcracker{/i}"),
        ## You may optionally provide an unlock condition as a string, which
        ## will be evaluated to determine if the song is unlocked or not.
        ## In this case, the song is unlocked when the persistent variable
        ## persistent.watched_intro is True.
        ## By default, songs are unlocked when the player has listened to them
        ## in-game. You can also set this to "True" to have a song be always
        ## unlocked.
        #unlock_condition="persistent.watched_intro",
    #)

    music_room.add(
        name=_("Aloha"),
        artist="Twisted Players",
        path="/audio/Aloha.ogg",
        ## The other information is omitted here, so it gets the defaults.
        ## That is, it gets the default cover art, no description, and it is
        ## unlocked when it is listened to in-game.
    )

    music_room.add(
        name=_("Beat Rush"),
        artist="Twisted Players",
        path="/audio/BeatRush.ogg",
    )

    music_room.add(
        name=_("Bubblegum Dreams"),
        artist="Zara Amour",
        path="/audio/Bubblegum Dreams.ogg",
    )

    music_room.add(
        name=_("Midnight Vibe"),
        artist="Twisted Players",
        path="/audio/Midnight Vibe.ogg",
    )

    music_room.add(
        name=_("Chasing Euphoria"),
        artist="Zara Amour",
        path="/audio/Chasing Euphoria.ogg",
    )

    music_room.add(
        name=_("Colliding Hearts"),
        artist="Mia Goldwyn",
        path="/audio/Colliding Hearts.ogg",
    )

    music_room.add(
        name=_("Dancing in the Groove"),
        artist="Cody Knight",
        path="/audio/Dancing in the Groove.ogg",
    )

    music_room.add(
        name=_("Deep Vibes"),
        artist="Twisted Players",
        path="/audio/Deep Vibes.ogg",
    )

    music_room.add(
        name=_("Echoes of Absence"),
        artist="Lila Vey",
        path="/audio/Echoes of Absence.ogg",
    )

    music_room.add(
        name=_("Elysium"),
        artist="Twisted Players",
        path="/audio/Elysium.ogg",
    )

    music_room.add(
        name=_("Endless Nights"),
        artist="Twisted Players",
        path="/audio/Endless Nights.ogg",
    )

    music_room.add(
        name=_("Fading Reflection"),
        artist="Twisted Players",
        path="/audio/Fading Reflection.ogg",
    )

    music_room.add(
        name=_("Ghost Circuit"),
        artist="Calla Dune",
        path="/audio/Ghost Circuit.ogg",
    )

    music_room.add(
        name=_("Glow in the Night"),
        artist="Twisted Players",
        path="/audio/Glow in the Night.ogg",
    )

    music_room.add(
        name=_("Growing Pains"),
        artist="Twisted Players",
        path="/audio/Growing Pains.ogg",
    )

    music_room.add(
        name=_("Guilty Pleasure"),
        artist="Twisted Players",
        path="/audio/Guilty Pleasure.ogg",
    )

    music_room.add(
        name=_("Haunted Hearts"),
        artist="Twisted Players",
        path="/audio/Haunted_Hearts.ogg",
    )

    music_room.add(
        name=_("Ignite the Night"),
        artist="Twisted Players",
        path="/audio/Ignite the Night.ogg",
    )

    music_room.add(
        name=_("Infinite Tonight"),
        artist="Twisted Players",
        path="/audio/Infinite_Tonight.ogg",
    )

    music_room.add(
        name=_("Island of Fantasy"),
        artist="Twisted Players",
        path="/audio/Island of Fantasy_v2.ogg",
    )

    music_room.add(
        name=_("Let It Matter"),
        artist="Twisted Players",
        path="/audio/Let It Matter.ogg",
    )

    music_room.add(
        name=_("Lost in the Night"),
        artist="Twisted Players",
        path="/audio/Lost in the Night.ogg",
    )

    music_room.add(
        name=_("Morning Tide"),
        artist="Twisted Players",
        path="/audio/Morning Tide.ogg",
    )

    music_room.add(
        name=_("Ocean Breeze"),
        artist="Twisted Players",
        path="/audio/Ocean_Breeze.ogg",
    )

    music_room.add(
        name=_("Ocean Echoes"),
        artist="Twisted Players",
        path="/audio/Ocean_Echoes.ogg",
    )

    music_room.add(
        name=_("Paradise Found"),
        artist="Twisted Players",
        path="/audio/Paradise_Found.ogg",
    )

    music_room.add(
        name=_("Poisoned Kindness"),
        artist="Twisted Players",
        path="/audio/Poisoned_Kindness.ogg",
    )

    music_room.add(
        name=_("Rainy Tones"),
        artist="Twisted Players",
        path="/audio/Rainy_Tones.ogg",
    )

    music_room.add(
        name=_("Regal Temptation"),
        artist="Twisted Players",
        path="/audio/Regal Temptation.ogg",
    )

    music_room.add(
        name=_("Rhythm Drift"),
        artist="Twisted Players",
        path="/audio/Rhythm Drift.ogg",
    )

    music_room.add(
        name=_("Rhythm Fest"),
        artist="Twisted Players",
        path="/audio/Rhythm Fest.ogg",
    )

    music_room.add(
        name=_("Rhythms of Reflection"),
        artist="Twisted Players",
        path="/audio/Rhythms of Reflection.ogg",
    )

    music_room.add(
        name=_("Smooth Love"),
        artist="Twisted Players",
        path="/audio/Smooth_Love.ogg",
    )

    music_room.add(
        name=_("Soul Echoes"),
        artist="Twisted Players",
        path="/audio/Soul_Echoes.ogg",
    )

    music_room.add(
        name=_("Soulflow"),
        artist="Twisted Players",
        path="/audio/Soulflow.ogg",
    )

    music_room.add(
        name=_("Sway in the Glow"),
        artist="Twisted Players",
        path="/audio/Sway in the Glow.ogg",
    )

    music_room.add(
        name=_("The Odyssey"),
        artist="Twisted Players",
        path="/audio/The Odyssey.ogg",
    )

    music_room.add(
        name=_("They Don't Compare"),
        artist="Twisted Players",
        path="/audio/They Don't Compare.ogg",
    )

    music_room.add(
        name=_("Tide"),
        artist="Twisted Players",
        path="/audio/Tide.ogg",
    )

    music_room.add(
        name=_("Tired Eyes"),
        artist="Twisted Players",
        path="/audio/Tired_Eyes.ogg",
    )

    music_room.add(
        name=_("Tropical Flight"),
        artist="Twisted Players",
        path="/audio/Tropical Flight.ogg",
    )

    music_room.add(
        name=_("Tropical Vibe"),
        artist="Twisted Players",
        path="/audio/Tropical Vibe.ogg",
    )

    music_room.add(
        name=_("Unchained"),
        artist="Twisted Players",
        path="/audio/Unchained.ogg",
    )

    music_room.add(
        name=_("Under the Starry Sky"),
        artist="Twisted Players",
        path="/audio/Under the Starry Sky.ogg",
    )

    music_room.add(
        name=_("Unstoppable"),
        artist="Twisted Players",
        path="/audio/Unstoppable.ogg",
    )

    music_room.add(
        name=_("Untamed"),
        artist="Twisted Players",
        path="/audio/Untamed.ogg",
    )

    music_room.add(
        name=_("Veil"),
        artist="Twisted Players",
        path="/audio/Veil.ogg",
    )

    music_room.add(
        name=_("Vibrante"),
        artist="Twisted Players",
        path="/audio/Vibrante.ogg",
    )

    music_room.add(
        name=_("Vivid Groove"),
        artist="Twisted Players",
        path="/audio/Vivid Groove.ogg",
    )

    music_room.add(
        name=_("Wave"),
        artist="Twisted Players",
        path="/audio/Wave.ogg",
    )

    music_room.add(
        name=_("Brand New Day"),
        artist="Jett Diamond",
        path="/audio/Brand New Day.ogg",
    )

    music_room.add(
        name=_("Can't Stop (Dark)"),
        artist="Zadie Quinn",
        path="/audio/Can't Stop (Dark).ogg",
    )

    
    music_room.add(
        name=_("Worth the Journey (Soul)"),
        artist="Leo Maxwell",
        path="/audio/Worth the Journey (Soul).ogg",
    )


    music_room.add(
        name=_("Worth the Journey (Remix)"),
        artist="Leo Maxwell",
        path="/audio/Worth the Journey (Remix).ogg",
    )




################################################################################
## CONFIGURATION VALUES
################################################################################
## Set this to True if you want to unlock all tracks in the music room during
## development. Set it to False to test the unlock conditions. Tracks will
## automatically obey unlock rules in a distribution regardless of the value
## of this configuration variable.
define myconfig.UNLOCK_TRACKS_FOR_DEVELOPMENT = False

################################################################################
## IMAGES & DEFINITIONS
################################################################################
## These colours are used by the colorize_button transform in the screens below
## to colorize the default music controls. You can change these if you want to
## use the provided images, or simply supply your own and remove the lines
## `at colorize_button` from the screen below.
define MUSIC_ROOM_IDLE_COLOR = "#ff8335"
define MUSIC_ROOM_HOVER_COLOR = "#f93c3e"
define MUSIC_ROOM_SELECTED_IDLE_COLOR = "#ff8335"
define MUSIC_ROOM_SELECTED_HOVER_COLOR = "#f93c3e"
define MUSIC_ROOM_INSENSITIVE_COLOR = "#888"

## Here are the default buttons used for the music controls below. You can
## update these or replace them.
image play_button = "gui/music_room/play.webp"
image pause_button = "gui/music_room/pause.webp"
image next_button = "gui/music_room/next.webp"
image prev_button = Transform("gui/music_room/next.webp", xzoom=-1.0)
image repeat_all_button = "gui/music_room/repeat all.webp"
## Note that this image is just a foreground on top of the repeat_all button!
image repeat_one_button = "gui/music_room/repeat 1.webp"
image shuffle_button = "gui/music_room/shuffle.webp"
image back_10_button = "gui/music_room/back_10.webp"
image forward_10_button = "gui/music_room/forward_10.webp"

## The "audio level" bars. These are optional to show next to the currently
## playing song. There are four bars that randomly change height.
define AUDIO_BAR_HEIGHT = 30
define AUDIO_BAR_WIDTH = 8
image audio_bar = Transform(MUSIC_ROOM_HOVER_COLOR,
    xysize=(AUDIO_BAR_WIDTH, AUDIO_BAR_HEIGHT))
transform audio_bar_move():
    yzoom renpy.random.random() ## Start at a random height
    block:
        ## Choose a random height to be
        choice:
            ease 0.2 yzoom 1.0
        choice:
            ease 0.2 yzoom 0.2
        choice:
            ease 0.2 yzoom 0.8
        choice:
            ease 0.2 yzoom 0.0
        choice:
            ease 0.2 yzoom 0.5
        repeat
## The final audio bars image, with four bars that randomly change height.
image audio_bars = HBox(
    At('audio_bar', audio_bar_move),
    At('audio_bar', audio_bar_move),
    At('audio_bar', audio_bar_move),
    At('audio_bar', audio_bar_move),
    yalign=1.0, ysize=AUDIO_BAR_HEIGHT,
)

################################################################################
## TRANSFORMS
################################################################################
## A transform that makes it easier to apply colours to the various buttons.
## The default images are black, so it uses ColorizeMatrix to colorize them.
## The colours are defined at the top of the file.
transform colorize_button(idle=MUSIC_ROOM_IDLE_COLOR,
        hover=MUSIC_ROOM_HOVER_COLOR,
        selected_idle=MUSIC_ROOM_SELECTED_IDLE_COLOR,
        selected_hover=MUSIC_ROOM_SELECTED_HOVER_COLOR,
        insensitive=MUSIC_ROOM_INSENSITIVE_COLOR):
    matrixcolor ColorizeMatrix(insensitive, "#fff")
    on idle:
        matrixcolor ColorizeMatrix(idle, "#fff")
    on hover:
        matrixcolor ColorizeMatrix(hover, "#fff")
    on insensitive:
        matrixcolor ColorizeMatrix(insensitive, "#fff")
    on selected_idle:
        matrixcolor ColorizeMatrix(selected_idle, "#fff")
    on selected_hover:
        matrixcolor ColorizeMatrix(selected_hover, "#fff")

## A simple transform to easily resize buttons. Used by some layouts.
transform zoom_button(z):
    zoom z

style mr_layout_frame:
    background "#21212d" xpadding 15 ypadding 10
style mr_layout_button:
    background None
style mr_layout_button_text:
    hover_color "#f93c3e" selected_color "#ff8335"
    idle_color "#f7f7ed" insensitive_color "#666"


################################################################################
## Styles for the track list, shared generally by the other rooms.
################################################################################
style track_list_frame:
    background "#21212d"
    yalign 0.0 xalign 0.0
    padding (25, 25)
style track_list_viewport:
    xfill False yfill False ymaximum config.screen_height-300
style track_list_side:
    spacing 20
style track_list_vbox:
    spacing 0
style track_list_button:
    right_padding 45
    background Transform("#ff8335", ysize=2, yalign=1.0)
    hover_foreground "#fff1"
    ypadding 15 xfill True
style track_list_hbox:
    xalign 0.0 spacing 18
style track_list_fixed:
    xsize 45 ysize 45 yalign 0.5
style track_list_text:
    color "#bfbfb9"
    insensitive_color "#666"
    size 14
style track_list_label:
    background None padding (2, 0)
style track_list_label_text:
    color "#f7f7ed" hover_color "#f93c3e" selected_color "#ff8335"
    insensitive_color "#666"
    size 19
style track_list_vscrollbar:
    thumb "#fc5f39" base_bar "#292835"

################################################################################
## SCREENS - VERSION 2
################################################################################
screen phonemusic_room(mr):
    #tag menu

    zorder 1
    add "/phone/music_back.png" xalign 0.5 yalign 0.5
    add "/phone/t_phone_back.png" xalign 0.5 yalign 0.5

    default current_track = mr.get_current_song()

    #add "#292835" ## The background image

    ## Buttons to go to the different layouts. Remove once you've decided
    ## on which layout to use.
    #use select_music_room_layout(mr, yalign=1.0, bottom_margin=100)

    ## To return to the main menu
    #textbutton _("Return") action Return() align (0.0, 1.0) text_size 40:
        #left_margin 25 bottom_margin 25

    ## If you'd like to use a sidebar with this layout, you will need to indent
    ## everything in this vbox one level right and include:
    ##
    # use game_menu(_("Music Room")):
    ##
    ## See music_room3 for code you can use if you have Easy Ren'Py GUI with
    ## a sidebar.
    fixed:
        xpos 0.36
        ypos 0.05
        imagebutton auto "/phone/music_home_%s.png" action Hide("phonemusic_room")

    vbox:
        style_prefix 'music_room2' first_spacing 80
        yalign 0.34
        vbox:
            ## The track list. These are displayed either in the order they
            ## were added to the music room in or in alphabetical order,
            ## depending on whether alphabetical sorting was turned on or not.
            ## You can arrange this however you like, with whichever information
            ## you like!
            vbox:
                yalign 0.0
                if current_track:
                    add current_track.art xalign 0.5 xsize 0.13 fit "contain"
                    label current_track.name xalign 0.5
                    text current_track.artist
                else:
                    add mr.default_art xalign 0.5 xsize 0.13 fit "contain"
                    label _("No song playing")
                    label _("---")


            frame:
                style_prefix 'track_list'
                ## If you want this to accommodate a sidebar, set the xsize
                ## smaller e.g. xsize config.screen_width-1050
                xsize 0.3
                ysize 0.55
                #xsize config.screen_width-1050
                #ysize config.screen_height-550
                viewport:
                    mousewheel True scrollbars "vertical" draggable True
                    has vbox
                    label _("Track List") style "music_room_title" xalign 0.5
                    for num, song in enumerate(mr.get_tracklist()):
                        button:
                            action mr.Play(song.path)
                            has hbox
                            fixed:
                                if song is current_track:
                                    ## If the song is currently playing, add a
                                    ## bit of flair with some audio bars.
                                    add Transform('audio_bars', ysize=30,
                                        xalign=0.5, yzoom=-1.0, yalign=0.55)
                                else:
                                    ## The track number
                                    text str(num+1) align (0.5, 0.55)
                            vbox:
                                spacing 4
                                ## Track info
                                label song.name
                                text song.artist

        ## The music controls
        ## This contains the music controls. You can remove whichever ones
        ## you don't need.
        hbox:
            spacing 22
            yalign -0.2
            ################## Back 10 seconds button ##################
            imagebutton:
                idle "back_10_button"
                at colorize_button()
                action mr.AdjustTrackPos(-10)
            ################## Shuffle button ##################
            imagebutton:
                idle "shuffle_button"
                at colorize_button(MUSIC_ROOM_INSENSITIVE_COLOR, MUSIC_ROOM_IDLE_COLOR)
                action mr.ToggleShuffle()
            ################## Previous, play/pause, next buttons ##################
            imagebutton:
                idle "prev_button"
                at colorize_button(), zoom_button(0.65)
                action mr.Previous()
            imagebutton:
                at colorize_button(), zoom_button(0.35)
                idle "pause_button" hover "pause_button"
                selected_idle "play_button" selected_hover "play_button"
                action mr.PlayAction()
            imagebutton:
                idle "next_button"
                at colorize_button(), zoom_button(0.65)
                action mr.Next()
            ################## Repeat all, repeat one buttons ##################
            imagebutton:
                at colorize_button(idle=MUSIC_ROOM_INSENSITIVE_COLOR,
                    hover=MUSIC_ROOM_IDLE_COLOR)
                idle "repeat_all_button"
                if mr.single_track:
                    foreground "repeat_one_button"
                action mr.CycleLoop()
            ################## Forward 10 seconds button ##################
            imagebutton:
                idle "forward_10_button"
                at colorize_button()
                action mr.AdjustTrackPos(10)

    fixed:
        xpos 0.35
        ypos 0.77
        xsize 0.2

        hbox:
            spacing 3
            ## This fixed (and the duration one below it) ensure that the
            ## pos and duration text don't change as the text updates (which
            ## could move the hbox around since it's changing size).
            fixed:
                yfit True xsize 100
                add mr.get_pos(style="music_room_pos")
            ## This makes a special music bar which shows the current position
            ## of the song, and also allows you to click the bar to skip around.
            ## It takes the same style properties as a regular bar, and in this
            ## case even gets the style "music_room_bar" because of the style
            ## prefix.
            music_bar room mr
            fixed:
                yfit True xsize 100
                add mr.get_duration(style="music_room_duration")
            ################## Music volume bar ##################
            null width 30
            imagebutton:
                idle "gui/music_room/volume.webp"
                at colorize_button(), zoom_button(0.45)
                hovered CaptureFocus("volume_slider_drop")
                action CaptureFocus("volume_slider_drop")

    ## This shows a volume bar popup when the volume control button is hovered
    ## or pressed.
    if GetFocusRect("volume_slider_drop"):
        default hide_volume = False
        nearrect:
            focus "volume_slider_drop" prefer_top True
            button:
                modal True
                action NullAction()
                hovered SetScreenVariable('hide_volume', False)
                unhovered SetScreenVariable('hide_volume', True)
                background None xpadding 65 top_padding 40
                bottom_padding 90 yoffset 75
                xalign 0.5 yalign 1.0
                vbar value MixerValue(mr.channel) xysize (25, 200):
                    xalign 0.5 top_bar "#21212d" thumb None
                    hovered SetScreenVariable('hide_volume', False)
                    bottom_bar "#fc5f39"
        if hide_volume:
            timer 1.0 action [ClearFocus("volume_slider_drop"),
                SetScreenVariable('hide_volume', False)]

################################################################################
## Styles for Music Room 2
################################################################################
style music_room2_vbox:
    xalign 0.5 spacing 10 yalign 0.5
style music_room2_hbox:
    spacing 15 xalign 0.5
style music_room2_image_button:
    align (0.5, 0.5)
style music_room2_bar:
    xsize 0.3 xalign 0.8 ysize 38
    right_bar "#21212d"
    left_bar "#fc5f39"
style music_room2_slider:
    xsize 200 xalign 0.5 ysize 25 yalign 0.5
    right_bar "#21212d"
    left_bar "#fc5f39"
    thumb None
style music_room2_label:
    background None xalign 0.0
style music_room2_label_text:
    color "#dbdb05"
style music_room2_text:
    color "#bfbfb9"

